/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1299;
import net.minecraft.class_1750;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.IBonemealable;
import shetiphian.core.common.IColored;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.client.misc.FoliageColor;

public abstract class BlockLeavesBase
extends class_2248
implements IBonemealable,
IColored,
class_3737 {
    public static final class_2758 DISTANCE = class_2741.field_12541;
    public static final class_2746 PERSISTENT = class_2741.field_12514;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected final PlantAPI.Tree treeType;

    public BlockLeavesBase(PlantAPI.Tree treeType) {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10503));
        this.treeType = treeType;
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(7))).method_11657((class_2769)PERSISTENT, (Comparable)Boolean.FALSE)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            TerraqueousClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581());
        });
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public PlantAPI.Tree getTreeType() {
        return this.treeType;
    }

    public int method_9505(class_2680 state, class_1922 world, class_2338 pos) {
        return 1;
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!((Boolean)state.method_11654((class_2769)PERSISTENT)).booleanValue() && (Integer)state.method_11654((class_2769)DISTANCE) == 7) {
            BlockLeavesBase.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
        world.method_8652(pos, BlockLeavesBase.updateDistance(state, (class_1936)world, pos), 3);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        int i = BlockLeavesBase.getDistance(neighborState) + 1;
        if (i != 1 || (Integer)state.method_11654((class_2769)DISTANCE) != i) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return state;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)PERSISTENT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        return BlockLeavesBase.updateDistance(blockState, (class_1936)context.method_8045(), context.method_8037());
    }

    private static class_2680 updateDistance(class_2680 state, class_1936 world, class_2338 pos) {
        int i = 7;
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            mPos.method_10101((class_2382)pos).method_10098(direction);
            i = Math.min(i, BlockLeavesBase.getDistance(world.method_8320((class_2338)mPos)) + 1);
            if (i == 1) break;
        }
        return (class_2680)state.method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(class_2680 neighbor) {
        if (TagHelper.isBlockInTag((class_2680)neighbor, (class_6862)class_3481.field_15475)) {
            return 0;
        }
        return TagHelper.isBlockInTag((class_2680)neighbor, (class_6862)class_3481.field_15503) && neighbor.method_28498((class_2769)DISTANCE) ? (Integer)neighbor.method_11654((class_2769)DISTANCE) : 7;
    }

    public static boolean canEntitySpawn(class_2680 state, class_1922 world, class_2338 pos, class_1299<?> type) {
        return type == class_1299.field_6081 || type == class_1299.field_6104;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
        class_2338 blockpos;
        class_2680 blockstate;
        if (!(!world.method_8520(pos.method_10084()) || rand.method_43048(15) != 1 || (blockstate = world.method_8320(blockpos = pos.method_10074())).method_26225() && blockstate.method_26206((class_1922)world, blockpos, class_2350.field_11036))) {
            double d0 = (float)pos.method_10263() + rand.method_43057();
            double d1 = (double)pos.method_10264() - 0.05;
            double d2 = (float)pos.method_10260() + rand.method_43057();
            world.method_8406((class_2394)class_2398.field_11232, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.treeType));
            }
            return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.treeType));
        }
        return 0xFFFFFF;
    }
}

