/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2473;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.misc.Tags;
import shetiphian.terraqueous.common.worldgen.feature.FeatureAppleTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureBananaTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCherryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureCoconutTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureLemonTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMangoTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMulberryTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureOrangeTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePeachTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePearTree;
import shetiphian.terraqueous.common.worldgen.feature.FeaturePlumTree;
import shetiphian.terraqueous.common.worldgen.feature.FeatureTreeBase;

public class BlockSapling
extends class_2473 {
    private final PlantAPI.Tree treeType;

    public BlockSapling(PlantAPI.Tree treeType) {
        super(null, class_4970.class_2251.method_9630((class_4970)class_2246.field_10394));
        this.treeType = treeType;
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581()));
    }

    protected boolean method_9695(class_2680 state, class_1922 world, class_2338 pos) {
        return super.method_9695(state, world, pos) || this.treeType == PlantAPI.Tree.COCONUT && TagHelper.isBlockInTag((class_2680)state, Tags.Blocks.SAND);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.isRegionLoaded((class_4538)world, pos, 1) && world.method_22339(pos.method_10084()) >= 9 && PlantFunctions.canSaplingGrow((class_1922)world, pos, this.treeType)) {
            this.method_9652(world, random, pos, state);
        }
    }

    private boolean isRegionLoaded(class_4538 world, class_2338 center, int range) {
        return world.method_22343(center.method_10069(-range, -range, -range), center.method_10069(range, range, range));
    }

    public void method_10507(class_3218 world, class_2338 pos, class_2680 state, class_5819 random) {
        if ((Integer)state.method_11654((class_2769)field_11476) == 0) {
            world.method_8652(pos, (class_2680)state.method_28493((class_2769)field_11476), 4);
        } else {
            this.spawn(world, pos, state, random);
        }
    }

    public boolean spawn(class_3218 world, class_2338 pos, class_2680 blockUnder, class_5819 random) {
        FeatureTreeBase treeFeature = BlockSapling.getTreeFeature(this.treeType);
        if (treeFeature == null) {
            return false;
        }
        world.method_8652(pos, class_2246.field_10124.method_9564(), 4);
        if (treeFeature.method_13151((class_5821<class_3111>)new class_5821(Optional.empty(), (class_5281)world, world.method_14178().method_12129(), random, pos, (class_3037)class_3037.field_13603))) {
            return true;
        }
        world.method_8652(pos, blockUnder, 4);
        return false;
    }

    private static FeatureTreeBase getTreeFeature(PlantAPI.Tree treeType) {
        return switch (treeType) {
            default -> throw new IncompatibleClassChangeError();
            case PlantAPI.Tree.APPLE -> new FeatureAppleTree(true);
            case PlantAPI.Tree.CHERRY -> new FeatureCherryTree(true);
            case PlantAPI.Tree.ORANGE -> new FeatureOrangeTree(true);
            case PlantAPI.Tree.PEAR -> new FeaturePearTree(true);
            case PlantAPI.Tree.PEACH -> new FeaturePeachTree(true);
            case PlantAPI.Tree.MANGO -> new FeatureMangoTree(true);
            case PlantAPI.Tree.LEMON -> new FeatureLemonTree(true);
            case PlantAPI.Tree.PLUM -> new FeaturePlumTree(true);
            case PlantAPI.Tree.BANANA -> new FeatureBananaTree(true);
            case PlantAPI.Tree.COCONUT -> new FeatureCoconutTree(true);
            case PlantAPI.Tree.MULBERRY -> new FeatureMulberryTree(true);
        };
    }
}

