/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeavesCoconut;
import shetiphian.terraqueous.common.misc.PlantFunctions;
import shetiphian.terraqueous.common.misc.Tags;

public class EntityCoconut
extends class_1297 {
    private int fallTime;
    public float size;
    private int age;
    private byte delay;
    private class_4048 currentSize = new class_4048(0.3f, 0.35f, false);
    private static final class_2940<Float> SIZE_DATA = class_2945.method_12791(EntityCoconut.class, (class_2941)class_2943.field_13320);

    public EntityCoconut(class_1937 world) {
        this(Roster.Entities.COCONUT, world);
    }

    public EntityCoconut(class_1299 type, class_1937 world) {
        super(type, world);
    }

    public EntityCoconut(class_1937 world, class_2338 pos, boolean treeSpawned) {
        this(world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, treeSpawned);
    }

    public EntityCoconut(class_1937 world, double x, double y, double z, boolean treeSpawned) {
        super(Roster.Entities.COCONUT, world);
        if (treeSpawned) {
            x = x - 0.2 + (double)Function.random.nextInt(4) / 10.0;
            y -= 0.02;
            z = z - 0.2 + (double)Function.random.nextInt(4) / 10.0;
        }
        this.method_5814(x, y, z);
        this.size = treeSpawned ? 0.2f : 1.0f;
        this.age = treeSpawned ? 1 : -1;
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.field_6011.method_12778(SIZE_DATA, (Object)Float.valueOf(this.size));
        this.method_36456((float)(Math.random() * 360.0));
    }

    protected void method_5693() {
        this.field_6011.method_12784(SIZE_DATA, (Object)Float.valueOf(this.size));
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5810() {
        return this.size >= 1.0f;
    }

    @NotNull
    public class_238 getCollisionBoundingBox() {
        if (this.size < 1.0f) {
            return new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new class_238(this.method_23317() - (double)0.15f, this.method_23318() - (double)0.15f, this.method_23321() - (double)0.15f, this.method_23317() + (double)0.15f, this.method_23318() + (double)0.15f, this.method_23321() + (double)0.15f);
    }

    public class_4048 method_18377(class_4050 pose) {
        return this.currentSize;
    }

    private void setSize(float width, float height) {
        this.currentSize = new class_4048(width, height, false);
        this.method_18382();
    }

    public void method_5773() {
        if (!this.method_37908().method_8608() && this.age == 0) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        this.size = ((Float)this.field_6011.method_12789(SIZE_DATA)).floatValue();
        if (this.size < 1.0f) {
            this.field_5960 = true;
            this.growTick();
        } else {
            this.updateTick();
        }
        this.field_6011.method_12778(SIZE_DATA, (Object)Float.valueOf(this.size));
    }

    private void growTick() {
        if (this.delay < 1) {
            if (this.method_23318() > this.field_6036) {
                this.method_5814(this.method_23317(), this.method_23318() - (this.method_23318() - this.field_6036), this.method_23321());
            }
            this.field_6036 = this.method_23318();
            boolean onLeaf = this.method_37908().method_8320(this.method_24515().method_10084()).method_26204() instanceof BlockLeavesCoconut;
            if (this.size + 0.0025f >= 1.0f && onLeaf && (this.method_37908().method_8608() || !PlantFunctions.dropFruit((class_1922)this.method_37908(), this.method_24515(), PlantAPI.Tree.COCONUT))) {
                this.size = 0.9999f;
                this.delay = (byte)20;
                if (this.method_17682() < 0.35f) {
                    this.setSize(0.3f, 0.35f);
                }
            } else {
                this.size += 0.0025f;
                this.method_5814(this.method_23317(), this.method_23318() - (double)0.0011f, this.method_23321());
                this.delay = 1;
                this.setSize(0.3f, 0.35f * this.size);
            }
            if (!onLeaf && this.size < 1.0f && this.method_37908().method_8608()) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        } else {
            this.delay = (byte)(this.delay - 1);
        }
    }

    private void updateTick() {
        if (this.method_17682() < 0.35f) {
            this.setSize(0.3f, 0.35f);
        }
        if (this.field_5960 && this.fallTime > 3) {
            this.field_5960 = false;
        }
        if (!this.method_24828()) {
            ++this.fallTime;
        } else if (this.fallTime > 0) {
            this.fallTime = 0;
        }
        super.method_5773();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_2338 pos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)this.method_23321()));
        class_2680 state = this.method_37908().method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2404 || state.method_51176()) {
            this.method_5698(null);
            return;
        }
        this.collideWithNearbyEntities();
        float friction = 0.98f;
        if (this.method_24828()) {
            pos = new class_2338(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.getCollisionBoundingBox().field_1322) - 1, class_3532.method_15357((double)this.method_23321()));
            friction = this.method_37908().method_8320(pos).method_26204().method_9499() * 0.98f;
        }
        this.method_18799(this.method_18798().method_18805((double)friction, 0.98, (double)friction));
        if (!this.method_37908().method_8608()) {
            int y = class_3532.method_15357((double)this.method_23318());
            if (this.fallTime > 100 && (y < 1 || y > 256)) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
            if (this.method_24828() && this.age > 0) {
                ++this.age;
            }
            if (this.age >= 6000) {
                this.method_5698(null);
            }
        }
    }

    private void collideWithNearbyEntities() {
        List list = this.method_37908().method_8335((class_1297)this, this.getCollisionBoundingBox().method_1009(0.2, 0.0, 0.2));
        if (!list.isEmpty()) {
            this.method_36456((float)(Math.random() * 360.0));
            this.method_5814(this.method_23317() + (this.field_5974.method_43056() ? -0.01 : 0.01), this.method_23318(), this.method_23321() + (this.field_5974.method_43056() ? -0.01 : 0.01));
            for (class_1297 entity : list) {
                if (entity instanceof class_1657) continue;
                this.method_5697(entity);
            }
        }
    }

    public class_3619 method_5657() {
        return class_3619.field_15974;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        int i = class_3532.method_15386((float)(distance - 1.0f));
        if (i > 0) {
            List list = this.method_37908().method_8335((class_1297)this, this.getCollisionBoundingBox().method_1009(0.25, 0.25, 0.25));
            for (class_1297 entity : list) {
                entity.method_5643((class_1282)Roster.DamageSources.COCONUT, (float)Math.min(class_3532.method_15375((float)((float)i * 2.0f)), 15));
            }
        }
        return false;
    }

    public boolean method_5698(@Nullable class_1297 entity) {
        if (this.size >= 0.9975f) {
            class_1799 stack;
            if (entity instanceof class_1309 && TagHelper.isItemInTag((class_1799)(stack = ((class_1309)entity).method_6047()), Tags.Items.RODS)) {
                int i = 3 + class_1890.method_8205((class_1309)((class_1309)entity));
                this.method_5762(-class_3532.method_15374((float)(entity.method_36454() * ((float)Math.PI / 180))) * (float)i * 0.5f, 0.1, class_3532.method_15362((float)(entity.method_36454() * ((float)Math.PI / 180))) * (float)i * 0.5f);
                return true;
            }
            this.method_5650(class_1297.class_5529.field_26999);
            class_1799 itemStack = this.method_31480();
            if (itemStack != null) {
                Function.dropItem((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)itemStack);
            }
        }
        return true;
    }

    protected void method_5652(class_2487 nbtTag) {
        nbtTag.method_10567("Time", (byte)this.fallTime);
        nbtTag.method_10548("Size", this.size);
        nbtTag.method_10569("Age", this.age);
    }

    protected void method_5749(class_2487 nbtTag) {
        this.fallTime = nbtTag.method_10571("Time") & 0xFF;
        this.size = nbtTag.method_10583("Size");
        this.age = nbtTag.method_10550("Age");
        this.field_6011.method_12778(SIZE_DATA, (Object)Float.valueOf(this.size));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5862() {
        return false;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)Roster.Items.COCONUT);
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }
}

