/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity.ai;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1646;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.block.BlockFlowers;

public class TaskTrimOvergrowth
extends class_4097<class_1646> {
    private final class_2248 blockGrass = Roster.Blocks.GRASS;
    private class_2338 posPlant;
    private long taskCooldown;
    private int idleTime;

    public TaskTrimOvergrowth() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18439, (Object)class_4141.field_18456, (Object)class_4140.field_18446, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    protected boolean shouldRun(class_3218 world, class_1646 villager) {
        if (!Terraqueous.CONFIG.COMMON.TWEAKS.VILLAGER.gardner_weeds) {
            return false;
        }
        class_5321 dimensionKey = world.method_27983();
        class_2338 villagerPosition = villager.method_24515();
        ArrayList list = Lists.newArrayList();
        int range = 8;
        for (int x = -range; x <= range; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos = villagerPosition.method_10069(x, y, z);
                    class_2248 block = world.method_8320(pos).method_26204();
                    if (!(block instanceof BlockFlowers) && (this.blockGrass == null || block != this.blockGrass)) continue;
                    list.add(class_4208.method_19443((class_5321)dimensionKey, (class_2338)pos));
                }
            }
        }
        if (!list.isEmpty()) {
            this.posPlant = ((class_4208)list.get(world.field_9229.method_43048(list.size()))).method_19446();
            return true;
        }
        return false;
    }

    protected void run(class_3218 world, class_1646 villager, long gameTime) {
        if (gameTime > this.taskCooldown && this.posPlant != null) {
            villager.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.posPlant));
            villager.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4099(this.posPlant), 0.5f, 1));
        }
    }

    protected void finishRunning(class_3218 world, class_1646 villager, long gameTime) {
        villager.method_18868().method_18875(class_4140.field_18446);
        villager.method_18868().method_18875(class_4140.field_18445);
        this.idleTime = 0;
        this.taskCooldown = gameTime + 10L;
    }

    protected void keepRunning(class_3218 world, class_1646 villager, long gameTime) {
        if (this.posPlant == null) {
            ++this.idleTime;
        } else if (this.posPlant.method_19769((class_2374)villager.method_19538(), 1.73)) {
            if (this.posPlant != null && gameTime > this.taskCooldown) {
                villager.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.posPlant));
                class_2680 statePlant = world.method_8320(this.posPlant);
                class_2248 blockPlant = statePlant.method_26204();
                int count = 0;
                int range = 3;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            class_2338 pos = this.posPlant.method_10069(x, y, z);
                            if (world.method_8320(pos).method_26204() != blockPlant || ++count <= 3) continue;
                            world.method_8650(this.posPlant, false);
                            this.posPlant = null;
                            return;
                        }
                    }
                }
                if (blockPlant instanceof BlockFlowers && (Integer)statePlant.method_11654((class_2769)BlockFlowers.SIZE) > 0) {
                    world.method_8501(this.posPlant, (class_2680)statePlant.method_11657((class_2769)BlockFlowers.SIZE, (Comparable)Integer.valueOf(0)));
                }
            }
        } else {
            ++this.idleTime;
            villager.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.posPlant));
            villager.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_4115)new class_4099(this.posPlant), 0.5f, 1));
        }
    }

    protected boolean shouldKeepRunning(class_3218 world, class_1646 villager, long gameTime) {
        return this.idleTime < 200;
    }
}

