/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.client.gui.GuiColorizer;

public class ItemColorizer
extends class_1792
implements ITabFiller,
IRGB16_Item,
IColored {
    private static final Map<class_2960, class_2960> MAP_CLASS_LOOKUP = new HashMap<class_2960, class_2960>();
    public static final int maxCharge = 512;

    public ItemColorizer(class_1792.class_1793 settings) {
        super(settings);
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            TerraqueousClient.colorize(this);
            TerraqueousClient.addItemPredicate(this, "charge", (stack, world, entity, seed) -> {
                double charge = (double)this.getCharge(stack) / 512.0;
                return charge <= 0.0 ? 0.0f : (charge < 0.25 ? 1.0f : (charge < 0.5 ? 2.0f : (charge < 0.75 ? 3.0f : 4.0f)));
            });
        });
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        entries.method_45420(ItemColorizer.newColorizer(0));
        entries.method_45420(ItemColorizer.newColorizer(512));
    }

    public static class_1799 newColorizer(int charge) {
        class_1799 stack = new class_1799((class_1935)Roster.Items.COLORIZER);
        stack.method_7948().method_10575("charge", (short)class_3532.method_15340((int)charge, (int)0, (int)512));
        return stack;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private void addCharge(class_1799 stack, int value) {
        int charge = this.getCharge(stack) + value;
        stack.method_7948().method_10575("charge", (short)class_3532.method_15340((int)charge, (int)0, (int)512));
    }

    private short getCharge(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("charge")) {
            nbt.method_10575("charge", (short)0);
        }
        return (short)class_3532.method_15340((int)nbt.method_10568("charge"), (int)0, (int)512);
    }

    private void useCharge(class_1799 stack) {
        this.addCharge(stack, -1);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)this.getDurabilityPercentage(stack) * 13.0f);
    }

    public double getDurabilityPercentage(class_1799 stack) {
        return this.getCharge(stack) > 0 ? 1.0 - (double)this.getCharge(stack) / 512.0 : 1.0;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        class_1799 dye;
        if (this.getCharge(stack) > 0 && (dye = new class_1799((class_1935)class_1769.method_7803((class_1767)this.getDyeColor(stack)))).method_7909().method_7847(dye, player, target, hand).method_23666()) {
            this.useCharge(stack);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        player.method_6104(hand);
        class_3965 mop = ItemColorizer.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348);
        if (mop != null && mop.method_17783() == class_239.class_240.field_1332) {
            return class_1271.method_22430((Object)stack);
        }
        if (player.method_5715()) {
            DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.openGUI(stack));
        } else {
            this.addCharge(stack, 4);
            this.playSound(world, player, Roster.Sounds.RATTLE);
        }
        return class_1271.method_22427((Object)stack);
    }

    @Environment(value=EnvType.CLIENT)
    private void openGUI(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemColorizer) {
            class_310.method_1551().method_1507((class_437)new GuiColorizer(stack));
        }
    }

    private void playSound(class_1937 world, class_1657 player, class_3414 sound) {
        if (player != null) {
            world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static class_1269 onItemUseFirst(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() instanceof ItemColorizer) {
            class_1838 context = new class_1838(world, player, hand, stack, hit);
            boolean success = stack.method_7909().method_7884(context) == class_1269.field_5812;
            return success ? class_1269.field_5812 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        int used = 0;
        class_1657 player = context.method_8036();
        if (player != null) {
            class_2350 facing;
            class_1799 stack = context.method_8041();
            class_1937 world = context.method_8045();
            class_2338 pos = context.method_8037();
            if (!player.method_7343(pos.method_10093(facing = context.method_8038()), facing, stack)) {
                return class_1269.field_5814;
            }
            if (player.method_5715()) {
                short index;
                if ((this.getCharge(stack) > 1 || player.method_31549().field_7477) && (index = ItemColorizer.getBlockColorIndex(world, pos, player)) > -1 && this.setRGB16(stack, index)) {
                    used = 2;
                    this.playSound(world, player, Roster.Sounds.PIPETTE);
                }
            } else if (this.getCharge(stack) > 3) {
                if (ItemColorizer.setBlockColor(world, pos, player, facing, this.getRGB16(stack))) {
                    used = 4;
                    this.playSound(world, player, Roster.Sounds.SPRAY);
                }
            } else {
                this.playSound(world, player, Roster.Sounds.SPRAY_AIR);
            }
            if (used > 0 && !player.method_31549().field_7477) {
                this.addCharge(stack, -used);
            }
        }
        return used > 0 ? class_1269.field_5812 : class_1269.field_5814;
    }

    public static void buildClassLookUpMap(Set<String> list) {
        MAP_CLASS_LOOKUP.clear();
        list.iterator().forEachRemaining(entry -> {
            try {
                String[] values = entry.split(":");
                class_2960 baseBlock = new class_2960(values[0], values[1]);
                class_2960 colorBlock = new class_2960(values[0], values[2].replace("*", "white"));
                MAP_CLASS_LOOKUP.put(baseBlock, colorBlock);
            }
            catch (Exception ignored) {
                Terraqueous.LOGGER.error("Couldn't process Colorizer class mapping '" + entry + "'");
            }
        });
    }

    public static boolean setBlockColor(class_1937 world, class_2338 pos, class_1657 player, class_2350 side, short index) {
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof IRGB16_Tile) {
            return ((IRGB16_Tile)tile).setRGB16(index, player);
        }
        class_1767 colorizerColor = class_1767.method_7791((int)RGB16Helper.getSimpleColor((short)index));
        class_2680 state = world.method_8320(pos);
        for (class_2769 prop : state.method_28501()) {
            class_1767 blockColor;
            if (!prop.method_11899().equals("color") || prop.method_11902() != class_1767.class || (blockColor = (class_1767)state.method_11654(prop)) == colorizerColor || !prop.method_11898().contains(colorizerColor)) continue;
            world.method_8652(pos, (class_2680)state.method_11657(prop, (Comparable)colorizerColor), 3);
            return true;
        }
        class_2248 block = state.method_26204();
        class_2960 registryName = class_7923.field_41175.method_10221((Object)block);
        if (registryName != null) {
            String dyeName;
            String[] specials;
            class_2960 altName;
            class_2248 newBlock;
            if (MAP_CLASS_LOOKUP.containsKey(registryName) && (newBlock = (class_2248)class_7923.field_41175.method_10223(altName = MAP_CLASS_LOOKUP.get(registryName))) != null) {
                registryName = altName;
                block = newBlock;
                state = ItemColorizer.copyProperties(state, newBlock);
            }
            String modId = registryName.method_12836();
            String blockName = registryName.method_12832();
            Object trimmed = "";
            for (String string : specials = new String[]{"light_blue", "lightblue", "light_gray", "lightgray", "silver"}) {
                if (!blockName.contains(string)) continue;
                trimmed = blockName.replace(string, "<dye>");
            }
            if (Strings.isNullOrEmpty((String)trimmed)) {
                for (String string : class_1767.values()) {
                    String dyeName3 = string.method_7792();
                    if (string == class_1767.field_7951 || string == class_1767.field_7967 || !blockName.contains(dyeName3)) continue;
                    trimmed = blockName.replace(dyeName3, "<dye>");
                }
            }
            if (Strings.isNullOrEmpty((String)trimmed)) {
                boolean atStart = true;
                boolean hasUnderscore = true;
                class_2248 finder = ItemColorizer.getBlock(modId, "white_" + blockName);
                if (finder == null) {
                    hasUnderscore = false;
                    finder = ItemColorizer.getBlock(modId, "white" + blockName);
                    if (finder == null) {
                        atStart = false;
                        hasUnderscore = true;
                        finder = ItemColorizer.getBlock(modId, blockName + "_white");
                        if (finder == null) {
                            hasUnderscore = false;
                            finder = ItemColorizer.getBlock(modId, blockName + "white");
                        }
                    }
                }
                if (finder != null) {
                    trimmed = (atStart ? (hasUnderscore ? "<dye>_" : "<dye>") : "") + blockName + (!atStart ? (hasUnderscore ? "_<dye>" : "<dye>") : "");
                    block = finder;
                    state = ItemColorizer.copyProperties(state, finder);
                }
            }
            Object newBlock2 = null;
            if (!Strings.isNullOrEmpty((String)trimmed) && (newBlock2 = ItemColorizer.getBlock(modId, ((String)trimmed).replace("<dye>", dyeName = colorizerColor.method_7792()))) == null) {
                if (colorizerColor == class_1767.field_7951) {
                    newBlock2 = ItemColorizer.getBlock(modId, ((String)trimmed).replace("<dye>", "lightblue"));
                } else if (colorizerColor == class_1767.field_7967 && (newBlock2 = ItemColorizer.getBlock(modId, ((String)trimmed).replace("<dye>", "lightgray"))) == null) {
                    newBlock2 = ItemColorizer.getBlock(modId, ((String)trimmed).replace("<dye>", "silver"));
                }
            }
            if (newBlock2 != null && newBlock2.getClass().equals(block.getClass())) {
                class_2680 newState = ItemColorizer.copyProperties(state, (class_2248)newBlock2);
                class_2487 tiletag = new class_2487();
                class_2586 class_25862 = world.method_8321(pos);
                if (class_25862 != null) {
                    tiletag = class_25862.method_38242();
                }
                if (Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)newState, (!(state.method_26204() instanceof class_2244) ? 1 : 0) != 0)) {
                    class_2586 class_25863 = world.method_8321(pos);
                    if (class_25863 != null) {
                        class_25863.method_11014(tiletag);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static class_2248 getBlock(String modId, String blockId) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(modId, blockId));
        return block != null && !Objects.equals(class_7923.field_41175.method_10221((Object)block), class_7923.field_41175.method_10137()) ? block : null;
    }

    private static class_2680 copyProperties(class_2680 original, class_2248 block) {
        class_2680 newState = block.method_9564();
        for (class_2769 prop : newState.method_28501()) {
            if (!original.method_28498(prop)) continue;
            newState = (class_2680)newState.method_11657(prop, original.method_11654(prop));
        }
        return newState;
    }

    public static short getBlockColorIndex(class_1937 world, class_2338 pos, class_1657 player) {
        RGB16 rgb16;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof IRGB16_Tile && (rgb16 = ((IRGB16_Tile)tile).getRGB16(player)) != null) {
            return rgb16.getIndex();
        }
        class_2680 state = world.method_8320(pos);
        for (class_2769 prop : state.method_28501()) {
            if (!prop.method_11899().equals("color") || prop.method_11902() != class_1767.class) continue;
            class_1767 color = (class_1767)state.method_11654(prop);
            return RGB16Helper.getIndexFor((class_1767)color);
        }
        class_2248 block = state.method_26204();
        class_2960 registryName = class_7923.field_41175.method_10221((Object)block);
        if (registryName != null) {
            String blockName = registryName.method_12832();
            if (blockName.contains("light_blue") || blockName.contains("lightblue")) {
                return RGB16Helper.getIndexFor((class_1767)class_1767.field_7951);
            }
            if (blockName.contains("light_gray") || blockName.contains("lightgray") || blockName.contains("silver")) {
                return RGB16Helper.getIndexFor((class_1767)class_1767.field_7967);
            }
            for (class_1767 dyeColor : class_1767.values()) {
                if (dyeColor == class_1767.field_7951 || dyeColor == class_1767.field_7967 || !blockName.contains(dyeColor.method_7792())) continue;
                return RGB16Helper.getIndexFor((class_1767)dyeColor);
            }
        }
        return RGB16Helper.getIndexFor((int)state.method_26205((class_1922)world, (class_2338)pos).field_16011);
    }

    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.method_7960()) {
            if (index == 1) {
                return RGB16Helper.getColor((short)RGB16StackHelper.readColorTag((class_1799)data.stack));
            }
            if (index == 2) {
                return RGB16Helper.getColor((short)RGB16StackHelper.readSimpleColorTag((class_1799)data.stack));
            }
        }
        return 0xFFFFFF;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 advanced) {
        tooltip.add((class_2561)class_2561.method_43471((String)"info.terraqueous.shakepowered"));
        String colorInfo = RGB16Helper.getTooltip((short)this.getRGB16(stack)) + "\u00a77 - ";
        class_1767 dye = this.getDyeColor(stack);
        colorInfo = colorInfo + "\u00a7" + ItemColorizer.getFormatCode(dye) + class_1074.method_4662((String)dye.method_7792(), (Object[])new Object[0]);
        tooltip.add((class_2561)class_2561.method_43470((String)colorInfo));
    }

    public static char getFormatCode(class_1767 color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case class_1767.field_7952 -> 'f';
            case class_1767.field_7946 -> '6';
            case class_1767.field_7958 -> '5';
            case class_1767.field_7951 -> 'b';
            case class_1767.field_7947 -> 'e';
            case class_1767.field_7961 -> 'a';
            case class_1767.field_7954 -> 'd';
            case class_1767.field_7944 -> '8';
            case class_1767.field_7967 -> '7';
            case class_1767.field_7955 -> '3';
            case class_1767.field_7945 -> '5';
            case class_1767.field_7966 -> '9';
            case class_1767.field_7957 -> '6';
            case class_1767.field_7942 -> '2';
            case class_1767.field_7964 -> '4';
            case class_1767.field_7963 -> '8';
        };
    }

    public short getRGB16(class_1799 stack) {
        return RGB16StackHelper.readColorTag((class_1799)stack);
    }

    public boolean setRGB16(class_1799 stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags((class_1799)stack, (short)rgbIndex);
    }

    private class_1767 getDyeColor(class_1799 stack) {
        return class_1767.method_7791((int)RGB16StackHelper.readSimpleColorTag((class_1799)stack));
    }

    public void setRGB16Preset(class_1799 stack, int preset, short rgbIndex, String name) {
        preset = class_3532.method_15340((int)preset, (int)0, (int)17);
        class_2487 nbt = stack.method_7948();
        class_2499 tagList = this.getNBTTagList(stack);
        class_2487 tagPresets = new class_2487();
        tagPresets.method_10575("rgb16", rgbIndex);
        tagPresets.method_10582("name", name);
        tagList.method_10606(preset, (class_2520)tagPresets);
        nbt.method_10566("rgb16presets", (class_2520)tagList);
    }

    public class_2499 getNBTTagList(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("rgb16presets")) {
            class_2499 tagList = new class_2499();
            short white = RGB16Helper.getIndexFor((String)"white");
            for (int index = 0; index < 18; index = (int)((byte)(index + 1))) {
                class_2487 tagPresets = new class_2487();
                tagPresets.method_10575("rgb16", white);
                tagPresets.method_10582("name", "\u00a7o<not set>");
                tagList.add((Object)tagPresets);
            }
            nbt.method_10566("rgb16presets", (class_2520)tagList);
        }
        return nbt.method_10554("rgb16presets", 10);
    }
}

