/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1834;
import net.minecraft.class_1838;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import shetiphian.core.common.BlockInfo;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.core.common.item.ItemWrench;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.client.TerraqueousClient;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.network.PacketBolt;

public class ItemHammer
extends ItemWrench
implements ITabFiller,
IStormForgeStackHandler {
    private static final short maxCharge = 25;

    public ItemHammer(class_1792.class_1793 settings) {
        super(settings.method_7896(Roster.Items.HAMMER));
        this.tooltip((stack, world, tooltip, advanced) -> {
            if (this.getCharge(stack) < 1) {
                tooltip.add(class_2561.method_43471((String)"info.terraqueous.hammer"));
            }
        });
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> TerraqueousClient.addItemPredicate((class_1792)this, "mode", (stack, world, entity, seed) -> this.getCharge(stack) > 0 ? 1.0f : 0.0f));
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        class_1799 stack = new class_1799((class_1935)this);
        this.addCharge(stack, 0);
        entries.method_45420(stack.method_7972());
        if (context.comp_1252()) {
            this.addCharge(stack, 25);
            entries.method_45420(stack);
        }
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    private void addCharge(class_1799 stack, int value) {
        int charge = this.getCharge(stack) + value;
        stack.method_7948().method_10575("charge", (short)class_3532.method_15340((int)charge, (int)0, (int)25));
    }

    private short getCharge(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("charge")) {
            nbt.method_10575("charge", (short)0);
        }
        return (short)class_3532.method_15340((int)nbt.method_10568("charge"), (int)0, (int)25);
    }

    private void useCharge(class_1799 stack) {
        this.addCharge(stack, -1);
    }

    public boolean method_7856(class_2680 state) {
        return state.method_26164(ToolHelper.MINEABLE_WITH_HAMMER) || state.method_26164(ToolHelper.MINEABLE_WITH_WRENCH);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return class_1834.field_8923.method_8027();
    }

    public class_1269 method_7884(class_1838 context) {
        class_1269 wrench = super.method_7884(context);
        return wrench == class_1269.field_5811 ? class_1802.field_8699.method_7884(context) : wrench;
    }

    public class_1814 method_7862(class_1799 stack) {
        return this.getCharge(stack) > 0 ? class_1814.field_8904 : super.method_7862(stack);
    }

    public boolean method_31567(class_1799 stack) {
        return this.getCharge(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)this.getDurabilityPercentage(stack) * 13.0f);
    }

    public double getDurabilityPercentage(class_1799 stack) {
        return this.getCharge(stack) > 0 ? 1.0 - (double)this.getCharge(stack) / 25.0 : 0.0;
    }

    @Override
    public boolean handleStack(class_1799 stack) {
        return true;
    }

    @Override
    public class_1799 processStack(class_1799 stack, int ticks, boolean struck, class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            StormForgeHelper.spawnLighting((class_3218)world, pos, false);
        }
        StormForgeHelper.moveFire(world, pos);
        this.addCharge(stack, 25);
        return stack;
    }

    @Override
    public boolean isFinished(class_1799 stack, int ticks, boolean struck, class_1937 world, class_2338 pos) {
        return true;
    }

    @Override
    public int ticksToComplete(class_1799 stack) {
        return 0;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.getCharge(stack) > 0) {
            player.method_6104(hand);
            class_243 end = null;
            class_1297 entityInFront = Function.getLivingEntityInFront((class_1937)world, (class_1297)player, (double)50.0);
            if (entityInFront != null) {
                end = entityInFront.method_19538();
            } else {
                BlockInfo info = Function.getBlockInfront((class_1937)world, (class_1297)player, (double)50.0, (boolean)false);
                if (info != null) {
                    class_2338 firePos = info.pos.method_10093(info.face);
                    class_243 class_2432 = end = world.method_22347(firePos) ? info.vec : null;
                    if (!world.method_8608() && world.field_9229.method_43056() && world.method_8450().method_8355(class_1928.field_19387) && class_2246.field_10036.method_9564().method_26184((class_4538)world, firePos)) {
                        world.method_8501(firePos, class_2246.field_10036.method_9564());
                    }
                }
            }
            if (end != null) {
                if (!world.method_8608() && world instanceof class_3218) {
                    class_243 start = player.method_19538().method_1031(0.0, (double)(player.method_18381(player.method_18376()) / 2.0f), 0.0);
                    PacketBolt packet = new PacketBolt(start, end, 0xFF80FF);
                    List entityList = world.method_18467(class_3222.class, new class_238(start.field_1352, start.field_1351, start.field_1350, start.field_1352 + 1.0, start.field_1351 + 1.0, start.field_1350 + 1.0).method_1009(16.0, 16.0, 16.0));
                    List entityList2 = world.method_18467(class_3222.class, new class_238(end.field_1352, end.field_1351, end.field_1350, end.field_1352 + 1.0, end.field_1351 + 1.0, end.field_1350 + 1.0).method_1009(16.0, 16.0, 16.0));
                    for (class_3222 entityPlayerMP : entityList2) {
                        if (entityList.contains(entityPlayerMP)) continue;
                        entityList.add(entityPlayerMP);
                    }
                    NetworkHandler.sendToList(packet, entityList);
                    world.method_43128(null, start.field_1352, start.field_1351, start.field_1350, Roster.Sounds.ARC, class_3419.field_15248, 1.0f, 1.0f);
                    world.method_43128(null, end.field_1352, end.field_1351, end.field_1350, Roster.Sounds.SPARK, class_3419.field_15248, 1.0f, 1.0f);
                    class_1538 passedBolt = (class_1538)class_1299.field_6112.method_5883(world);
                    if (passedBolt != null) {
                        passedBolt.method_29495(end);
                        passedBolt.method_29498(false);
                        List list = world.method_18467(class_1297.class, new class_238(end.field_1352, end.field_1351, end.field_1350, end.field_1352 + 1.0, end.field_1351 + 1.0, end.field_1350 + 1.0).method_1009(2.0, 2.0, 2.0));
                        for (class_1297 entity : list) {
                            entity.method_5800((class_3218)world, passedBolt);
                        }
                    }
                }
                if (!player.method_31549().field_7477) {
                    this.useCharge(stack);
                }
            }
        }
        return super.method_7836(world, player, hand);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 hand) {
        class_1799 extraModifiers = new class_1799((class_1935)class_1802.field_8600);
        extraModifiers.method_7978(class_1893.field_9121, this.getCharge(stack) > 0 ? 8 : 3);
        extraModifiers.method_7978(class_1893.field_9118, 3);
        player.method_5783(Roster.Sounds.HAMMER, 1.0f, 1.0f);
        ItemToolWithDamageSource.onLeftClickEntity((class_1657)player, (class_1297)target, null, (class_1799)extraModifiers);
        return class_1269.field_5812;
    }

    public String method_7866(class_1799 stack) {
        return super.method_7866(stack) + (this.getCharge(stack) > 0 ? ".activated" : "");
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7886(class_1799 stack) {
        return this.getCharge(stack) > 0;
    }
}

