/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.minecraft.class_1792;
import net.minecraft.class_7923;
import shetiphian.core.common.TagHelper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;

public class ConfiguredItemListUtil {
    private static List<String> processTag(String listName, String tagResource) {
        ArrayList<String> itemIds = new ArrayList<String>();
        try {
            for (class_1792 item : TagHelper.getItems((String)tagResource)) {
                try {
                    itemIds.add(class_7923.field_41178.method_10221((Object)item).toString());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception error) {
            Terraqueous.LOGGER.debug("Error processing " + listName + " tag entry '" + tagResource + "'; " + error);
        }
        return itemIds;
    }

    public static Map<String, String> generateItemList(String listName, Set<String> whitelist, Set<String> blacklist) {
        if (whitelist != null) {
            String resource;
            Matcher matcher;
            HashMap<String, String> items = new HashMap<String, String>();
            ArrayList<String> removeItems = new ArrayList<String>();
            ArrayList<String> removeMods = new ArrayList<String>();
            for (String include : whitelist) {
                try {
                    matcher = Configuration.Validators.PATTERN_ITEM.matcher(include);
                    if (!matcher.find()) continue;
                    resource = matcher.group(1);
                    String count = matcher.group(2);
                    if (include.startsWith("tag|")) {
                        ConfiguredItemListUtil.processTag(listName, resource).forEach(name -> {
                            if (!items.containsKey(name)) {
                                items.put((String)name, count);
                            }
                        });
                        continue;
                    }
                    if (items.containsKey(resource)) continue;
                    items.put(resource, count);
                }
                catch (Exception error) {
                    Terraqueous.LOGGER.debug("Error processing " + listName + " whitelist entry '" + include + "'; " + error);
                }
            }
            if (blacklist != null) {
                for (String exclude : blacklist) {
                    try {
                        matcher = Configuration.Validators.PATTERN_ITEM.matcher(exclude);
                        if (matcher.find()) {
                            resource = matcher.group(1);
                            if (exclude.startsWith("tag|")) {
                                removeItems.addAll(ConfiguredItemListUtil.processTag(listName, resource));
                                continue;
                            }
                            removeItems.add(resource);
                            continue;
                        }
                        if (!exclude.startsWith("mod|")) continue;
                        removeMods.add(exclude.substring(4));
                    }
                    catch (Exception error) {
                        Terraqueous.LOGGER.debug("Error processing " + listName + " blacklist entry '" + exclude + "'; " + error);
                    }
                }
                for (String remove : removeItems) {
                    items.remove(remove);
                }
                items.entrySet().removeIf(entry -> {
                    String modName = ((String)entry.getKey()).split(":")[0];
                    return removeMods.contains(((String)entry.getKey()).split(":")[0]);
                });
            }
            return items;
        }
        return new HashMap<String, String>();
    }
}

