/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class PlantFunctions {
    private static Table<PlantAPI.Plant, PlantAPI.PlantEvent, int[]> PLANT_CHANCE_TABLE = HashBasedTable.create();
    private static int[] SAPLING_GROW_CHANCE;
    private static int[] FRUIT_FLOWER_CHANCE;
    private static int[] FRUIT_GROW_CHANCE;
    private static int[] FRUIT_FALL_CHANCE;

    public static void load(Configuration.CommonFile.Menu_Plants plants, Configuration.CommonFile.Menu_Trees trees) {
        Configuration.CommonFile.Menu_Plants.SubMenu_PlantGrow grow = plants.PLANT_GROW;
        Configuration.CommonFile.Menu_Plants.SubMenu_PlantSpread spread = plants.PLANT_SPREAD;
        Configuration.CommonFile.Menu_Plants.SubMenu_FruitGrow fruit_grow = plants.FRUIT_GROW;
        PLANT_CHANCE_TABLE = HashBasedTable.create();
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.FLOWER, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{grow.flower_normal, grow.flower_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.FLOWER, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{spread.flower_normal, spread.flower_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.GRASS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{grow.grass_normal, grow.grass_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.GRASS, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{spread.grass_normal, spread.grass_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.PINEAPPLE, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{grow.pineapple_normal, grow.pineapple_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.PINEAPPLE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{fruit_grow.pineapple_normal, fruit_grow.pineapple_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.CACTUS, (Object)PlantAPI.PlantEvent.PlantGrow, (Object)new int[]{grow.cactus_day, grow.cactus_night});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.CACTUS, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{fruit_grow.cactus_day, fruit_grow.cactus_night});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.GRAPEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{spread.grapevine_normal, spread.grapevine_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.GRAPEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{fruit_grow.grapevine_normal, fruit_grow.grapevine_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.LIFEVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{spread.lifevine_normal, spread.lifevine_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.LIFEVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{fruit_grow.lifevine_normal, fruit_grow.lifevine_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.DEATHVINE, (Object)PlantAPI.PlantEvent.PlantSpread, (Object)new int[]{spread.deathvine_normal, spread.deathvine_rain});
        PLANT_CHANCE_TABLE.put((Object)PlantAPI.Plant.DEATHVINE, (Object)PlantAPI.PlantEvent.FruitGrow, (Object)new int[]{fruit_grow.deathvine_normal, fruit_grow.deathvine_rain});
        SAPLING_GROW_CHANCE = trees.SAPLING_GROW.getValues();
        FRUIT_FLOWER_CHANCE = trees.FLOWER_GROW.getValues();
        FRUIT_GROW_CHANCE = trees.FRUIT_GROW.getValues();
        FRUIT_FALL_CHANCE = trees.FRUIT_FALL.getValues();
    }

    private static int safeGet(int[] array, int index) {
        return index > -1 && index < array.length ? array[index] : 0;
    }

    public static boolean canGrow(class_1937 world, class_2338 pos, PlantAPI.Plant plant) {
        if (!PLANT_CHANCE_TABLE.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow)) {
            return false;
        }
        int[] chances = (int[])PLANT_CHANCE_TABLE.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantGrow);
        int index = plant == PlantAPI.Plant.CACTUS ? (world.method_8530() ? 0 : 1) : (world.method_8430(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantGrow, plant, (class_1922)world, pos, PlantFunctions.safeGet(chances, index));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canSpread(class_1937 world, class_2338 pos, PlantAPI.Plant plant) {
        if (!PLANT_CHANCE_TABLE.contains((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread)) {
            return false;
        }
        int[] chances = (int[])PLANT_CHANCE_TABLE.get((Object)plant, (Object)PlantAPI.PlantEvent.PlantSpread);
        int index = plant == PlantAPI.Plant.CACTUS ? (world.method_8530() ? 0 : 1) : (world.method_8430(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.PlantSpread, plant, (class_1922)world, pos, PlantFunctions.safeGet(chances, index));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean canGrowFruit(class_1937 world, class_2338 pos, PlantAPI.Plant plant) {
        if (!PLANT_CHANCE_TABLE.contains((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow)) {
            return false;
        }
        int[] chances = (int[])PLANT_CHANCE_TABLE.get((Object)plant, (Object)PlantAPI.PlantEvent.FruitGrow);
        int index = plant == PlantAPI.Plant.CACTUS ? (world.method_8530() ? 0 : 1) : (world.method_8430(1.0f) > 1.0f ? 1 : 0);
        int eventChance = PlantAPI.getPlantEventChance(PlantAPI.PlantEvent.FruitGrow, plant, (class_1922)world, pos, PlantFunctions.safeGet(chances, index));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static byte getMaxPlacementAttempts(class_1922 world, class_2338 pos, PlantAPI.Plant plant) {
        return switch (plant) {
            case PlantAPI.Plant.FLOWER -> PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerMaxAttempts, world, pos, 5);
            case PlantAPI.Plant.GRASS -> PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassMaxAttempts, world, pos, 5);
            default -> 0;
        };
    }

    public static byte[] getSpreadRadius(class_1922 world, class_2338 pos, PlantAPI.Plant plant) {
        byte radius = switch (plant) {
            case PlantAPI.Plant.FLOWER -> PlantAPI.getPlacementValue(PlantAPI.PlacementValue.FlowerSpreadRadius, world, pos, 3);
            case PlantAPI.Plant.GRASS -> PlantAPI.getPlacementValue(PlantAPI.PlacementValue.GrassSpreadRadius, world, pos, 3);
            default -> 0;
        };
        byte[] spreadRadius = new byte[]{radius > 0 ? radius : (byte)1, (byte)(radius / 3 * 2) > 0 ? (byte)(radius / 3 * 2) : (byte)1};
        return spreadRadius;
    }

    public static boolean canSaplingGrow(class_1922 world, class_2338 pos, PlantAPI.Tree tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.SaplingGrow, tree, world, pos, PlantFunctions.safeGet(SAPLING_GROW_CHANCE, tree.ordinal()));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruitFlower(class_1922 world, class_2338 pos, PlantAPI.Tree tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFlower, tree, world, pos, PlantFunctions.safeGet(FRUIT_FLOWER_CHANCE, tree.ordinal()));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean growFruit(class_1922 world, class_2338 pos, PlantAPI.Tree tree) {
        int eventChance = PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitGrow, tree, world, pos, PlantFunctions.safeGet(FRUIT_GROW_CHANCE, tree.ordinal()));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }

    public static boolean dropFruit(class_1922 world, class_2338 pos, PlantAPI.Tree tree) {
        int eventChance = Terraqueous.CONFIG.COMMON.TREES.fruit_stays_on_trees ? 0 : PlantAPI.getTreeEventChance(PlantAPI.TreeEvent.FruitFall, tree, world, pos, PlantFunctions.safeGet(FRUIT_FALL_CHANCE, tree.ordinal()));
        return eventChance > 0 && Function.random.nextInt(eventChance) == 0;
    }
}

