/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.inventory.InventorySideAssignable;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.common.inventory.ContainerCraftBench;
import shetiphian.terraqueous.common.inventory.InventoryCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCrafting;

public class TileEntityCraftBench
extends TileEntityCrafting {
    public GhostMatrix ghostMatrix = new GhostMatrix((class_2586)this);
    public boolean isCloud;
    private static final List<class_3955> EMPTY_LIST = Collections.emptyList();
    private List<class_3955> recipes = EMPTY_LIST;
    private int recipeIndex = 0;

    public TileEntityCraftBench(boolean isCloud, class_2338 pos, class_2680 state) {
        super(isCloud ? Roster.Tiles.CLOUD_CRAFTBENCH : Roster.Tiles.CRAFTBENCH, pos, state);
        this.isCloud = isCloud;
        this.inventory = new InventoryCraftBench(this, isCloud);
    }

    @Override
    protected void buildNBT(class_2487 nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.method_10556("isCloud", this.isCloud);
        this.ghostMatrix.writeToNBT(nbtTag);
        nbtTag.method_10569("index", this.recipeIndex);
    }

    @Override
    protected void processNBT(class_2487 nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.method_10577("isCloud");
        this.ghostMatrix.readFromNBT(nbtTag);
        this.recipeIndex = nbtTag.method_10550("index");
    }

    protected void processNBT_SaveOnly(class_2487 nbtTag) {
        if (nbtTag.method_10545("itemOutput") || nbtTag.method_10545("itemsChest") || nbtTag.method_10545("itemsBuffer")) {
            class_1799 itemOutput = this.itemReader(nbtTag, "itemOutput");
            class_1799[] itemsChest = this.listReader(nbtTag.method_10554("itemsChest", 10), 27);
            class_1799[] itemsBuffer = this.listReader(nbtTag.method_10554("itemsBuffer", 10), 2);
            class_1799[] contents = new class_1799[30];
            contents[0] = itemOutput;
            System.arraycopy(itemsChest, 0, contents, 1, 27);
            System.arraycopy(itemsBuffer, 0, contents, 28, 2);
            ((InventoryCraftBench)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    public void setCraftResult(class_1799 stack) {
        this.inventory.method_5447(0, stack);
    }

    public boolean ghostCraftCanTakeStack(class_1657 player) {
        return this.getSourceSlots(player) != null;
    }

    public void ghostCraftOnPickupFromSlot(class_1657 player, class_1799 stack) {
        this.doCraft(player, stack);
    }

    public boolean canCraft() {
        return this.getSourceSlots(null) != null;
    }

    @NotNull
    public class_1799 doCraft(class_1657 player, class_1799 stack) {
        int index;
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return stack;
        }
        short[] sourceSlots = this.getSourceSlots(player);
        if (sourceSlots == null) {
            return class_1799.field_8037;
        }
        Pair[] stackLocations = new Pair[9];
        GhostMatrix craftMatrix = new GhostMatrix((class_2586)this);
        for (int index2 = 0; index2 < 9; index2 = (int)((byte)(index2 + 1))) {
            int slot = sourceSlots[index2];
            if (slot > -1) {
                class_1799 sourceStack;
                InventorySideAssignable container = this.inventory;
                if (slot >= 1000 && player != null) {
                    slot -= 1000;
                    container = player.method_31548();
                }
                craftMatrix.copyStackTo(index2, !(sourceStack = container.method_5438(slot)).method_7960() ? sourceStack.method_7972().method_7971(1) : class_1799.field_8037);
                stackLocations[index2] = Pair.of((Object)container, (Object)slot);
                continue;
            }
            craftMatrix.copyStackTo(index2, class_1799.field_8037);
        }
        ContainerCraftBench.GhostMatrixCrafting ghostCrafting = new ContainerCraftBench.GhostMatrixCrafting((class_1263)craftMatrix);
        class_3955 recipe = this.getRecipe(ghostCrafting, this.recipeIndex);
        class_1799 tempStack = stack;
        if (recipe != null) {
            tempStack = recipe.method_8116((class_1263)ghostCrafting, (class_5455)class_5455.field_40585);
        }
        if (recipe == null || tempStack.method_7960()) {
            if (player != null && Function.areItemStacksEqual((class_1799)player.field_7512.method_34255(), (class_1799)stack)) {
                if (player.field_7512.method_34255().method_7947() > stack.method_7947()) {
                    player.field_7512.method_34255().method_7939(player.field_7512.method_34255().method_7947() - stack.method_7947());
                } else {
                    player.field_7512.method_34254(class_1799.field_8037);
                }
            }
            return class_1799.field_8037;
        }
        tempStack.method_7939(stack.method_7947());
        stack = tempStack;
        if (player == null) {
            // empty if block
        }
        if (player != null) {
            new ContainerCraftBench.SlotGhostCrafting(player, ghostCrafting).onPlayerCrafting(stack);
        }
        class_2371 remainingItems = recipe.method_8111((class_1263)ghostCrafting);
        for (index = 0; index < remainingItems.size(); ++index) {
            class_1799 craftStack = craftMatrix.method_5438(index);
            class_1799 remainStack = (class_1799)remainingItems.get(index);
            if (!craftStack.method_7960()) {
                craftMatrix.method_5434(index, 1);
                craftStack = craftMatrix.method_5438(index);
            }
            if (remainStack.method_7960()) continue;
            if (craftStack.method_7960()) {
                craftMatrix.method_5447(index, remainStack);
                continue;
            }
            if (class_1799.method_31577((class_1799)craftStack, (class_1799)remainStack)) {
                remainStack.method_7933(craftStack.method_7947());
                craftMatrix.method_5447(index, remainStack);
                continue;
            }
            if (player != null && player.method_31548().method_7394(remainStack)) continue;
            Function.dropItem((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)remainStack);
        }
        for (index = 0; index < 9; index = (int)((byte)(index + 1))) {
            if (stackLocations[index] == null) continue;
            class_1263 container = (class_1263)stackLocations[index].getLeft();
            int slot = (Integer)stackLocations[index].getRight();
            container.method_5434(slot, 1);
            class_1799 unusedStack = craftMatrix.method_5438(index);
            if (unusedStack.method_7960()) continue;
            if (unusedStack.method_7909().method_7846()) {
                container.method_5447(slot, unusedStack);
                continue;
            }
            class_1799[] itemsChest = new class_1799[27];
            System.arraycopy(this.inventory.getContents(), 1, itemsChest, 0, 27);
            byte outputSlot = this.getOutputSlot(itemsChest, unusedStack, false);
            if (outputSlot > -1) {
                class_1799 stackInSlot = this.inventory.method_5438(1 + outputSlot);
                if (!stackInSlot.method_7960()) {
                    stackInSlot.method_7933(unusedStack.method_7947());
                    continue;
                }
                this.inventory.method_5447(1 + outputSlot, unusedStack);
                continue;
            }
            Function.dropItem((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)unusedStack);
        }
        this.method_5431();
        return stack;
    }

    private class_1799[] inventoryToArray(class_1263 inventory) {
        class_1799[] array = new class_1799[inventory.method_5439()];
        for (int slotId = 0; slotId < array.length; ++slotId) {
            class_1799 stackInSlot = inventory.method_5438(slotId);
            array[slotId] = !stackInSlot.method_7960() ? stackInSlot.method_7972() : class_1799.field_8037;
        }
        return array;
    }

    private short[] getSourceSlots(class_1657 player) {
        class_3955 recipe = this.getRecipe(new ContainerCraftBench.GhostMatrixCrafting((class_1263)this.ghostMatrix), this.recipeIndex);
        if (recipe == null) {
            return null;
        }
        short[] slots = new short[9];
        class_1799[] matrix = this.ghostMatrix.getContents();
        class_1799[] chest = this.inventoryToArray((class_1263)this.inventory);
        class_1799[] playerInv = player != null ? this.inventoryToArray((class_1263)player.method_31548()) : null;
        block0: for (int matrixSlot = 0; matrixSlot < 9; matrixSlot = (int)((byte)(matrixSlot + 1))) {
            class_1799 target = matrix[matrixSlot];
            if (target.method_7960()) {
                slots[matrixSlot] = -1;
                continue;
            }
            boolean foundItem = false;
            for (int pass = 0; pass < 2; ++pass) {
                int chestSlot;
                if (pass > 0 && playerInv == null) {
                    return null;
                }
                int n = chestSlot = pass == 0 ? this.findItem(target, null, chest, 1) : this.findItem(target, null, playerInv, 0);
                if (chestSlot >= 0) {
                    foundItem = true;
                } else {
                    for (class_1856 ingredient : recipe.method_8117()) {
                        if (!ingredient.method_8093(target) || (chestSlot = pass == 0 ? this.findItem(null, ingredient, chest, 1) : this.findItem(null, ingredient, playerInv, 0)) < 0) continue;
                        foundItem = true;
                        break;
                    }
                }
                if (foundItem) {
                    if (pass == 0) {
                        slots[matrixSlot] = (short)chestSlot;
                        chest[chestSlot].method_7934(1);
                        if (!chest[chestSlot].method_7960()) continue block0;
                        chest[chestSlot] = class_1799.field_8037;
                        continue block0;
                    }
                    slots[matrixSlot] = (short)(chestSlot + 1000);
                    playerInv[chestSlot].method_7934(1);
                    if (!playerInv[chestSlot].method_7960()) continue block0;
                    playerInv[chestSlot] = class_1799.field_8037;
                    continue block0;
                }
                if (pass <= 0 && playerInv != null) continue;
                return null;
            }
        }
        return slots;
    }

    private int findItem(class_1799 target, class_1856 ingredient, class_1799[] inventory, int start) {
        for (int slot = start; slot < start + 27; ++slot) {
            class_1799 stack = inventory[slot];
            if (stack.method_7960() || (target == null || !Function.areItemStacksEqual((class_1799)target, (class_1799)stack)) && (ingredient == null || !ingredient.method_8093(stack))) continue;
            return slot;
        }
        return -1;
    }

    public class_3955 getRecipe(class_1715 inventory, int index) {
        if (this.recipes == null || this.recipes == EMPTY_LIST) {
            this.onCraftMatrixChanged(inventory);
        }
        if (!this.recipes.isEmpty() && index <= this.recipes.size()) {
            return this.recipes.get(index);
        }
        return null;
    }

    public void onCraftMatrixChanged(class_1715 inventory) {
        this.recipes.clear();
        this.recipeIndex = 0;
        if (this.field_11863 != null) {
            this.recipes = this.field_11863.method_8433().method_17877(class_3956.field_17545, (class_1263)inventory, this.field_11863);
            if (this.recipes == null) {
                this.recipes = new ArrayList<class_3955>();
            }
            return;
        }
        this.recipes = EMPTY_LIST;
    }

    private static class GhostMatrix
    extends InventoryInternal {
        GhostMatrix(class_2586 invOwner) {
            super(invOwner, "ghostmatrix", 9, 1, "CraftBench-CraftMatrix");
        }

        void copyStackTo(int slotId, class_1799 itemStack) {
            if (this.okSlotId(slotId) && !itemStack.method_7960()) {
                this.contents[slotId] = itemStack.method_7972();
                this.contents[slotId].method_7939(1);
            }
        }
    }
}

