/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.common.block.BlockFurnace;
import shetiphian.terraqueous.common.inventory.InventoryCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntityCraftFurnace
extends TileEntityAutoCrafting {
    private int[] smeltTime = new int[2];
    private int burnTime;
    private int burnValue;
    public boolean isCloud;
    private boolean isSmelting;
    private final short[] finishTime;
    public final class_3913 furnaceData = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> TileEntityCraftFurnace.this.burnTime;
                case 1 -> TileEntityCraftFurnace.this.burnValue;
                case 2 -> TileEntityCraftFurnace.this.smeltTime[0];
                case 3 -> TileEntityCraftFurnace.this.smeltTime[1];
                case 4 -> TileEntityCraftFurnace.this.finishTime[0];
                case 5 -> TileEntityCraftFurnace.this.finishTime[1];
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityCraftFurnace.this.burnTime = value;
                    break;
                }
                case 1: {
                    TileEntityCraftFurnace.this.burnValue = value;
                    break;
                }
                case 2: {
                    TileEntityCraftFurnace.this.smeltTime[0] = value;
                    break;
                }
                case 3: {
                    TileEntityCraftFurnace.this.smeltTime[1] = value;
                    break;
                }
                case 4: {
                    TileEntityCraftFurnace.this.finishTime[0] = (short)value;
                    break;
                }
                case 5: {
                    TileEntityCraftFurnace.this.finishTime[1] = (short)value;
                }
            }
        }

        public int method_17389() {
            return 6;
        }
    };

    public TileEntityCraftFurnace(boolean isCloud, class_2338 pos, class_2680 state) {
        super(isCloud ? Roster.Tiles.CLOUD_CRAFTFURNACE : Roster.Tiles.CRAFTFURNACE, pos, state);
        this.isCloud = isCloud;
        this.inventory = new InventoryCraftFurnace(this, this.isCloud);
        this.finishTime = this.isCloud ? new short[]{600, 600} : new short[]{250, 250};
    }

    @Override
    protected void buildNBT(class_2487 nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.method_10556("isCloud", this.isCloud);
        nbtTag.method_10556("isSmelting", this.isSmelting);
    }

    protected void buildNBT_SaveOnly(class_2487 nbtTag) {
        nbtTag.method_10539("smeltTime", this.smeltTime);
        nbtTag.method_10569("burnTime", this.burnTime);
        nbtTag.method_10569("burnValue", this.burnValue);
        super.buildNBT_SaveOnly(nbtTag);
    }

    @Override
    protected void processNBT(class_2487 nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.method_10577("isCloud");
        this.isSmelting = nbtTag.method_10577("isSmelting");
    }

    protected void processNBT_SaveOnly(class_2487 nbtTag) {
        if (nbtTag.method_10545("smeltTime")) {
            this.smeltTime = nbtTag.method_10561("smeltTime");
        }
        this.burnTime = nbtTag.method_10550("burnTime");
        this.burnValue = nbtTag.method_10550("burnValue");
        if (nbtTag.method_10545("itemsFuel") || nbtTag.method_10545("itemsInput") || nbtTag.method_10545("itemsSmelt") || nbtTag.method_10545("itemsOutput")) {
            class_1799[] itemsFuel = this.listReader(nbtTag.method_10554("itemsFuel", 10), 3);
            class_1799[] itemsInput = this.listReader(nbtTag.method_10554("itemsInput", 10), 6);
            class_1799[] itemsSmelt = this.listReader(nbtTag.method_10554("itemsSmelt", 10), 2);
            class_1799[] itemsOutput = this.listReader(nbtTag.method_10554("itemsOutput", 10), 6);
            class_1799[] contents = new class_1799[17];
            System.arraycopy(itemsFuel, 0, contents, 0, 3);
            System.arraycopy(itemsInput, 0, contents, 3, 6);
            System.arraycopy(itemsSmelt, 0, contents, 9, 2);
            System.arraycopy(itemsOutput, 0, contents, 11, 6);
            ((InventoryCraftFurnace)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    @Override
    public void tick() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        boolean finalTick = false;
        if (this.burnTime > 0) {
            --this.burnTime;
            finalTick = this.burnTime == 0;
        }
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            class_1799 smeltStack = this.inventory.method_5438(9 + slotSmelt);
            if (!smeltStack.method_7960()) {
                Triple<class_1799, Float, Integer> result;
                if (this.burnTime > 0 || this.isCloud || finalTick) {
                    int n = slotSmelt;
                    this.smeltTime[n] = this.smeltTime[n] + 1;
                    if (this.isCloud && this.field_11863.method_8419()) {
                        int n2 = slotSmelt;
                        this.smeltTime[n2] = this.smeltTime[n2] + 1;
                    }
                    if (this.isCloud && this.field_11863.method_8546()) {
                        int n3 = slotSmelt;
                        this.smeltTime[n3] = this.smeltTime[n3] + 1;
                    }
                }
                boolean isItemSmeltable = !((class_1799)(result = this.getSmelted(smeltStack)).getLeft()).method_7960();
                this.finishTime[slotSmelt] = (short)((double)((Integer)result.getRight()).intValue() * (this.isCloud ? 3.0 : 1.5));
                if (this.smeltTime[slotSmelt] >= this.finishTime[slotSmelt] || !isItemSmeltable) {
                    class_1799[] itemsOutput = new class_1799[6];
                    System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                    byte outputSlot = this.getOutputSlot(itemsOutput, smeltStack, isItemSmeltable);
                    if (outputSlot > -1) {
                        class_1799 output = isItemSmeltable ? (class_1799)result.getLeft() : smeltStack.method_7972().method_7971(1);
                        class_1799 stackInSlot = this.inventory.method_5438(11 + outputSlot);
                        if (isItemSmeltable) {
                            this.addExperience(((Float)result.getMiddle()).floatValue());
                        }
                        if (!stackInSlot.method_7960()) {
                            stackInSlot.method_7933(output.method_7947());
                        } else {
                            this.inventory.method_5447(11 + outputSlot, output);
                        }
                        this.inventory.method_5447(9 + slotSmelt, class_1799.field_8037);
                        this.smeltTime[slotSmelt] = 0;
                        this.getNextSmeltItem(slotSmelt);
                        smeltStack = this.inventory.method_5438(9 + slotSmelt);
                        this.method_5431();
                    }
                }
            }
            if (!smeltStack.method_7960() || this.getNextSmeltItem(slotSmelt) || this.smeltTime[slotSmelt] <= 0) continue;
            this.smeltTime[slotSmelt] = 0;
        }
        boolean[] inUse = new boolean[2];
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            inUse[slotSmelt] = !this.inventory.method_5438(9 + slotSmelt).method_7960() && this.smeltTime[slotSmelt] < this.finishTime[slotSmelt];
        }
        if (!this.isCloud && this.burnTime < 1 && (inUse[0] || inUse[1])) {
            for (int slotFuel = 0; slotFuel < 3; slotFuel = (int)((byte)(slotFuel + 1))) {
                int value;
                class_1799 stackFuel = this.inventory.method_5438(slotFuel);
                if (stackFuel.method_7960() || (value = ((Integer)FuelRegistry.INSTANCE.get((class_1935)stackFuel.method_7909())).intValue()) <= 0) continue;
                this.burnTime = this.burnValue = value;
                if (stackFuel.method_7947() > 1) {
                    stackFuel.method_7934(1);
                } else if (stackFuel.method_7909().method_7857()) {
                    this.inventory.method_5447(slotFuel, new class_1799((class_1935)stackFuel.method_7909().method_7858()));
                } else {
                    this.inventory.method_5447(slotFuel, class_1799.field_8037);
                }
                this.method_5431();
                break;
            }
        }
        if (this.isSmelting) {
            if (!inUse[0] && !inUse[1] || !this.isCloud && this.burnTime < 1) {
                this.isSmelting = false;
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BlockFurnace.LIT, (Comparable)Boolean.valueOf(this.isSmelting)), 3);
                this.method_5431();
            }
        } else if ((inUse[0] || inUse[1]) && (this.isCloud || !this.isCloud && this.burnTime > 0)) {
            this.isSmelting = true;
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)BlockFurnace.LIT, (Comparable)Boolean.valueOf(this.isSmelting)), 3);
            this.method_5431();
        }
    }

    private boolean getNextSmeltItem(int slotSmelt) {
        for (int slotInput = 0; slotInput < 6; slotInput = (int)((byte)(slotInput + 1))) {
            class_1799 stackInput = this.inventory.method_5438(3 + slotInput);
            if (stackInput.method_7960()) continue;
            if (this.isSmeltable(stackInput)) {
                this.inventory.method_5447(9 + slotSmelt, stackInput.method_7971(1));
                if (stackInput.method_7960()) {
                    this.inventory.method_5447(3 + slotInput, class_1799.field_8037);
                }
                this.smeltTime[slotSmelt] = 0;
                this.method_5431();
                return true;
            }
            boolean removed = false;
            int size = stackInput.method_7947();
            for (int count = 0; count < size; ++count) {
                class_1799 temp = stackInput.method_7972();
                temp.method_7939(1);
                class_1799[] itemsOutput = new class_1799[6];
                System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                byte outputSlot = this.getOutputSlot(itemsOutput, temp, false);
                if (outputSlot <= -1) continue;
                class_1799 stackInSlot = this.inventory.method_5438(11 + outputSlot);
                if (!stackInSlot.method_7960()) {
                    stackInSlot.method_7933(1);
                } else {
                    this.inventory.method_5447(11 + outputSlot, temp);
                }
                stackInput.method_7934(1);
                if (stackInput.method_7960()) {
                    this.inventory.method_5447(3 + slotInput, class_1799.field_8037);
                }
                removed = true;
            }
            if (!removed) continue;
            this.method_5431();
        }
        return false;
    }

    public int getSmeltTime(int slot) {
        return slot < 2 ? this.smeltTime[slot] : 0;
    }

    public void setSmeltTime(int slot, int value) {
        if (slot > -1 && slot < 2) {
            this.smeltTime[slot] = value;
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnValue() {
        return this.burnValue;
    }

    @Environment(value=EnvType.CLIENT)
    public int getCookProgressScaled(int item, int graphicWidth) {
        return this.smeltTime[item] == 0 ? 0 : this.smeltTime[item] * graphicWidth / this.finishTime[item];
    }

    @Environment(value=EnvType.CLIENT)
    public int getFuelProgressScaled(int graphicWidth) {
        return this.burnTime == 0 || this.burnValue == 0 ? 0 : class_3532.method_15340((int)(this.burnTime * graphicWidth / this.burnValue), (int)1, (int)graphicWidth);
    }
}

