/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2826;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5867;
import net.minecraft.class_6862;
import shetiphian.core.common.IPlantable;
import shetiphian.core.common.ISoil;
import shetiphian.core.common.TagHelper;

public abstract class AbstractTreeFeature
extends class_3031<class_3111> {
    protected IPlantable sapling = (IPlantable)class_2246.field_10394;
    protected final boolean doBlockNotify;
    private final class_3341 DUMMY_BOUNDING_BOX = new class_3341(0, 0, 0, 0, 0, 0);

    public AbstractTreeFeature(boolean doBlockNotify) {
        super(class_3111.field_24893);
        this.doBlockNotify = doBlockNotify;
    }

    public static boolean isStateAtPosition(class_1936 world, class_2338 pos, Predicate<class_2680> predicate) {
        return predicate.test(world.method_8320(pos));
    }

    protected static boolean canBeReplacedByLogs(class_1936 world, class_2338 pos) {
        return AbstractTreeFeature.isStateAtPosition(world, pos, state -> {
            class_2248 block = state.method_26204();
            return state.method_26215() || state.method_26164(class_3481.field_15503) || block == class_2246.field_10219 || AbstractTreeFeature.method_23396((class_2680)state) || state.method_26164(class_3481.field_15475) || state.method_26164(class_3481.field_15462) || block == class_2246.field_10597;
        });
    }

    protected static boolean isAirOrLeaves(class_1936 world, class_2338 pos) {
        return AbstractTreeFeature.isStateAtPosition(world, pos, state -> state.method_26215() || state.method_26164(class_3481.field_15503));
    }

    protected static boolean isSoil(class_1936 world, class_2338 pos, IPlantable sapling) {
        if (sapling == null) {
            return AbstractTreeFeature.isStateAtPosition(world, pos, state -> {
                class_2248 block = state.method_26204();
                return AbstractTreeFeature.method_23396((class_2680)state) || block == class_2246.field_10219;
            });
        }
        return AbstractTreeFeature.isStateAtPosition(world, pos, state -> ISoil.canBlockSustainPlant((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)class_2350.field_11036, (IPlantable)sapling));
    }

    protected void setBlock(class_1936 world, class_5867 bulkAccess, class_2338 pos, class_2680 state) {
        this.setStateWithCheck(world, bulkAccess, pos, state);
    }

    protected final void setLogState(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_2338 pos, class_2680 state, class_3341 boundingBox) {
        this.setStateWithCheck(world, bulkAccess, pos, state);
        if (boundingBox.equals((Object)this.DUMMY_BOUNDING_BOX)) {
            boundingBox.method_29299((class_2382)pos);
        } else {
            boundingBox.method_34389(pos);
        }
        if (TagHelper.isBlockInTag((class_2680)state, (class_6862)class_3481.field_15475)) {
            changedBlocks.add(pos.method_10062());
        }
    }

    private void setStateWithCheck(class_1936 world, class_5867 bulkAccess, class_2338 pos, class_2680 state) {
        class_2826 levelChunkSection;
        if (this.doBlockNotify && world instanceof class_3218) {
            class_3218 sWorld = (class_3218)world;
            sWorld.method_8652(pos, state, 19);
        } else if (bulkAccess != null && (levelChunkSection = bulkAccess.method_33944(pos)) != null) {
            int rX = class_4076.method_18684((int)pos.method_10263());
            int rY = class_4076.method_18684((int)pos.method_10264());
            int rZ = class_4076.method_18684((int)pos.method_10260());
            levelChunkSection.method_12256(rX, rY, rZ, state, false);
        }
    }

    public boolean method_13151(class_5821<class_3111> context) {
        boolean result;
        class_5281 world = context.method_33652();
        if (this.doBlockNotify && world instanceof class_3218) {
            result = this.place(world, null, context.method_33655(), context.method_33654());
        } else {
            try (class_5867 bulkAccess = new class_5867((class_1936)world);){
                result = this.place(world, bulkAccess, context.method_33655(), context.method_33654());
            }
        }
        return result;
    }

    public boolean place(class_5281 world, class_5867 bulkAccess, class_2338 position, class_5819 random) {
        HashSet set = Sets.newHashSet();
        class_3341 boundingBox = this.DUMMY_BOUNDING_BOX.method_19311(0, 0, 0);
        boolean flag = this.place(set, (class_1936)world, bulkAccess, random, position, boundingBox);
        if (boundingBox.method_35415() > boundingBox.method_35418()) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_244 part = new class_244(boundingBox.method_35414(), boundingBox.method_14660(), boundingBox.method_14663());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if (flag && !set.isEmpty()) {
            for (class_2338 sPos : Lists.newArrayList((Iterable)set)) {
                if (boundingBox.method_14662((class_2382)sPos)) {
                    part.method_1049(sPos.method_10263() - boundingBox.method_35415(), sPos.method_10264() - boundingBox.method_35416(), sPos.method_10260() - boundingBox.method_35417());
                }
                for (class_2350 direction : class_2350.values()) {
                    class_2680 blockstate;
                    mutable.method_10101((class_2382)sPos).method_10098(direction);
                    if (set.contains(mutable) || !(blockstate = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541)) continue;
                    ((Set)list.get(0)).add(mutable.method_10062());
                    this.setStateWithCheck((class_1936)world, bulkAccess, (class_2338)mutable, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                    if (!boundingBox.method_14662((class_2382)mutable)) continue;
                    part.method_1049(mutable.method_10263() - boundingBox.method_35415(), mutable.method_10264() - boundingBox.method_35416(), mutable.method_10260() - boundingBox.method_35417());
                }
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set1 = (Set)list.get(l - 1);
            Set set2 = (Set)list.get(l);
            for (class_2338 sPos : set1) {
                if (boundingBox.method_14662((class_2382)sPos)) {
                    part.method_1049(sPos.method_10263() - boundingBox.method_35415(), sPos.method_10264() - boundingBox.method_35416(), sPos.method_10260() - boundingBox.method_35417());
                }
                for (class_2350 direction1 : class_2350.values()) {
                    int k;
                    class_2680 blockstate1;
                    mutable.method_10101((class_2382)sPos).method_10098(direction1);
                    if (set1.contains(mutable) || set2.contains(mutable) || !(blockstate1 = world.method_8320((class_2338)mutable)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                    class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                    this.setStateWithCheck((class_1936)world, bulkAccess, (class_2338)mutable, blockstate2);
                    if (boundingBox.method_14662((class_2382)mutable)) {
                        part.method_1049(mutable.method_10263() - boundingBox.method_35415(), mutable.method_10264() - boundingBox.method_35416(), mutable.method_10260() - boundingBox.method_35417());
                    }
                    set2.add(mutable.method_10062());
                }
            }
        }
        return flag;
    }

    protected abstract boolean place(Set<class_2338> var1, class_1936 var2, class_5867 var3, class_5819 var4, class_2338 var5, class_3341 var6);

    protected IPlantable getSapling() {
        return this.sapling;
    }

    public void setSapling(IPlantable sapling) {
        this.sapling = sapling;
    }
}

