/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen.feature;

import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_5819;
import net.minecraft.class_5867;
import shetiphian.core.common.IPlantable;
import shetiphian.terraqueous.Roster;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockLeaves;
import shetiphian.terraqueous.common.worldgen.WorldGenerator;
import shetiphian.terraqueous.common.worldgen.feature.AbstractTreeFeature;
import shetiphian.terraqueous.common.worldgen.feature.FeatureMiniTreeBase;

public abstract class FeatureTreeBase
extends AbstractTreeFeature {
    protected FeatureMiniTreeBase MINI_TREE;
    protected class_2680 LOG;
    protected class_2680 LOG_X;
    protected class_2680 LOG_Z;
    protected class_2680 WOOD;
    protected class_2680 LEAVES;
    protected class_2680 LEAVES_FLOWER;
    protected class_2680 LEAVES_FRUIT;
    protected boolean rotateMap = false;

    public FeatureTreeBase(boolean doBlockNotifyOnPlace, PlantAPI.Tree tree) {
        super(doBlockNotifyOnPlace);
        class_2248 sapling = switch (tree) {
            default -> throw new IncompatibleClassChangeError();
            case PlantAPI.Tree.APPLE -> Roster.Blocks.APPLE_SAPLING;
            case PlantAPI.Tree.CHERRY -> Roster.Blocks.CHERRY_SAPLING;
            case PlantAPI.Tree.ORANGE -> Roster.Blocks.ORANGE_SAPLING;
            case PlantAPI.Tree.PEAR -> Roster.Blocks.PEAR_SAPLING;
            case PlantAPI.Tree.PEACH -> Roster.Blocks.PEACH_SAPLING;
            case PlantAPI.Tree.MANGO -> Roster.Blocks.MANGO_SAPLING;
            case PlantAPI.Tree.LEMON -> Roster.Blocks.LEMON_SAPLING;
            case PlantAPI.Tree.PLUM -> Roster.Blocks.PLUM_SAPLING;
            case PlantAPI.Tree.COCONUT -> Roster.Blocks.COCONUT_SAPLING;
            case PlantAPI.Tree.BANANA -> Roster.Blocks.BANANA_SAPLING;
            case PlantAPI.Tree.MULBERRY -> Roster.Blocks.MULBERRY_SAPLING;
        };
        this.setSapling((IPlantable)sapling);
        this.setup(tree);
    }

    protected void setup(PlantAPI.Tree tree) {
        this.LOG = (switch (tree) {
            default -> throw new IncompatibleClassChangeError();
            case PlantAPI.Tree.APPLE -> Roster.Blocks.APPLE_LOG;
            case PlantAPI.Tree.CHERRY -> Roster.Blocks.CHERRY_LOG;
            case PlantAPI.Tree.ORANGE -> Roster.Blocks.ORANGE_LOG;
            case PlantAPI.Tree.PEAR -> Roster.Blocks.PEAR_LOG;
            case PlantAPI.Tree.PEACH -> Roster.Blocks.PEACH_LOG;
            case PlantAPI.Tree.MANGO -> Roster.Blocks.MANGO_LOG;
            case PlantAPI.Tree.LEMON -> Roster.Blocks.LEMON_LOG;
            case PlantAPI.Tree.PLUM -> Roster.Blocks.PLUM_LOG;
            case PlantAPI.Tree.COCONUT -> Roster.Blocks.COCONUT_LOG;
            case PlantAPI.Tree.BANANA -> Roster.Blocks.BANANA_LOG;
            case PlantAPI.Tree.MULBERRY -> Roster.Blocks.MULBERRY_LOG;
        }).method_9564();
        this.LOG_X = (class_2680)this.LOG.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11048);
        this.LOG_Z = (class_2680)this.LOG.method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11051);
        this.WOOD = (switch (tree) {
            default -> throw new IncompatibleClassChangeError();
            case PlantAPI.Tree.APPLE -> Roster.Blocks.APPLE_WOOD;
            case PlantAPI.Tree.CHERRY -> Roster.Blocks.CHERRY_WOOD;
            case PlantAPI.Tree.ORANGE -> Roster.Blocks.ORANGE_WOOD;
            case PlantAPI.Tree.PEAR -> Roster.Blocks.PEAR_WOOD;
            case PlantAPI.Tree.PEACH -> Roster.Blocks.PEACH_WOOD;
            case PlantAPI.Tree.MANGO -> Roster.Blocks.MANGO_WOOD;
            case PlantAPI.Tree.LEMON -> Roster.Blocks.LEMON_WOOD;
            case PlantAPI.Tree.PLUM -> Roster.Blocks.PLUM_WOOD;
            case PlantAPI.Tree.COCONUT -> Roster.Blocks.COCONUT_WOOD;
            case PlantAPI.Tree.BANANA -> Roster.Blocks.BANANA_WOOD;
            case PlantAPI.Tree.MULBERRY -> Roster.Blocks.MULBERRY_WOOD;
        }).method_9564();
        this.LEAVES = (switch (tree) {
            default -> throw new IncompatibleClassChangeError();
            case PlantAPI.Tree.APPLE -> Roster.Blocks.APPLE_LEAVES;
            case PlantAPI.Tree.CHERRY -> Roster.Blocks.CHERRY_LEAVES;
            case PlantAPI.Tree.ORANGE -> Roster.Blocks.ORANGE_LEAVES;
            case PlantAPI.Tree.PEAR -> Roster.Blocks.PEAR_LEAVES;
            case PlantAPI.Tree.PEACH -> Roster.Blocks.PEACH_LEAVES;
            case PlantAPI.Tree.MANGO -> Roster.Blocks.MANGO_LEAVES;
            case PlantAPI.Tree.LEMON -> Roster.Blocks.LEMON_LEAVES;
            case PlantAPI.Tree.PLUM -> Roster.Blocks.PLUM_LEAVES;
            case PlantAPI.Tree.COCONUT -> Roster.Blocks.COCONUT_LEAVES;
            case PlantAPI.Tree.BANANA -> Roster.Blocks.BANANA_LEAVES;
            case PlantAPI.Tree.MULBERRY -> Roster.Blocks.MULBERRY_LEAVES;
        }).method_9564();
        this.LEAVES_FLOWER = BlockLeaves.getAltVariant(this.LEAVES, false);
        this.LEAVES_FRUIT = BlockLeaves.getAltVariant(this.LEAVES, true);
    }

    protected abstract int getTreeWidth();

    protected abstract int getFoliageHeight();

    protected abstract int getTrunkHeight(class_5819 var1);

    protected abstract byte getMapValue(int var1);

    protected class_2680 getBlockState(int mapValue, class_5819 random) {
        switch (mapValue) {
            case 1: {
                return this.LOG;
            }
            case 2: {
                return this.rotateMap ? this.LOG_Z : this.LOG_X;
            }
            case 3: {
                return this.rotateMap ? this.LOG_X : this.LOG_Z;
            }
            case 4: {
                return this.WOOD;
            }
            case 6: {
                if (random.method_43048(15) == 0) {
                    return this.LEAVES_FLOWER;
                }
                if (random.method_43048(15) == 0) {
                    return this.LEAVES_FRUIT;
                }
            }
            case 5: {
                return this.LEAVES;
            }
        }
        return class_2246.field_10124.method_9564();
    }

    @Override
    protected final boolean place(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_5819 random, class_2338 position, class_3341 boundingBox) {
        if (!FeatureTreeBase.isStateAtPosition(world, position, state -> state.method_26204() instanceof class_2473) && WorldGenerator.isBlacklisted(world, Terraqueous.CONFIG.COMMON.GENERATOR.DIM_BLACKLIST.trees)) {
            return false;
        }
        return this.placeTree(changedBlocks, world, bulkAccess, random, position, boundingBox) || this.MINI_TREE != null && this.MINI_TREE.placeTree(changedBlocks, world, bulkAccess, random, position, boundingBox);
    }

    protected boolean placeTree(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_5819 random, class_2338 position, class_3341 boundingBox) {
        int index;
        int sZ;
        int chZ;
        int sX;
        int chX;
        int sY;
        int treeWidth = this.getTreeWidth();
        int foliageHeight = this.getFoliageHeight();
        int trunkHeight = this.getTrunkHeight(random);
        if (position.method_10264() < 1 || position.method_10264() + 1 + trunkHeight + foliageHeight > WorldGenerator.getMaxWorldHeight(world)) {
            return false;
        }
        if (!FeatureTreeBase.isSoil(world, position.method_10074(), this.sapling)) {
            return false;
        }
        class_2338.class_2339 mPos = new class_2338.class_2339();
        mPos.method_10101((class_2382)position);
        int chY = position.method_10264();
        for (sY = 0; sY < trunkHeight; sY = (int)((byte)(sY + 1))) {
            mPos.method_33098(chY);
            if (!FeatureTreeBase.canBeReplacedByLogs(world, (class_2338)mPos)) {
                return false;
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    index = this.getIndex(sX, sY, sZ, treeWidth);
                    if (this.getMapValue(index) > 0) {
                        mPos.method_10103(chX, chY, chZ);
                        if (!FeatureTreeBase.canBeReplacedByLogs(world, (class_2338)mPos)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        mPos.method_10101((class_2382)position);
        chY = position.method_10264();
        for (sY = 0; sY < trunkHeight; sY = (int)((byte)(sY + 1))) {
            mPos.method_33098(chY);
            if (FeatureTreeBase.isAirOrLeaves(world, (class_2338)mPos)) {
                this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(1, random), boundingBox);
            }
            ++chY;
        }
        for (sY = 0; sY < foliageHeight; sY = (int)((byte)(sY + 1))) {
            chX = position.method_10263() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (int)((byte)(sX + 1))) {
                chZ = position.method_10260() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (int)((byte)(sZ + 1))) {
                    mPos.method_10103(chX, chY, chZ);
                    index = this.getIndex(sX, sY, sZ, treeWidth);
                    byte mapValue = this.getMapValue(index);
                    if (mapValue > 0 && FeatureTreeBase.isAirOrLeaves(world, (class_2338)mPos)) {
                        this.setState(changedBlocks, world, bulkAccess, (class_2338)mPos, this.getBlockState(mapValue, random), boundingBox);
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        this.postPlacement(changedBlocks, world, bulkAccess, random, position, boundingBox, trunkHeight);
        return true;
    }

    private int getIndex(int sX, int sY, int sZ, int treeWidth) {
        if (this.rotateMap) {
            return sY * treeWidth * treeWidth + sZ + sX * treeWidth;
        }
        return sY * treeWidth * treeWidth + sX + sZ * treeWidth;
    }

    protected void setState(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_2338 pos, class_2680 state, class_3341 boundingBox) {
        if (state != null && !state.method_26215()) {
            this.setLogState(changedBlocks, world, bulkAccess, pos, state, boundingBox);
        }
    }

    protected void postPlacement(Set<class_2338> changedBlocks, class_1936 world, class_5867 bulkAccess, class_5819 random, class_2338 position, class_3341 boundingBox, int yOffset) {
    }
}

